using System;
using Server.Network;
using Server.Misc;
using System.Collections;
using Server.Mobiles;

namespace Server.Misc
{
   public class EvoGolemSelfRessTimer : Timer
   {
      private Mobile m_Mobile;

      public EvoGolemSelfRessTimer( Mobile m, double t) : base( TimeSpan.FromSeconds( t ))
      {
         Priority = TimerPriority.OneSecond;
         m_Mobile = m;
         m_Mobile.Emote( "*{0} je vyrazen z provozu*", m_Mobile.Name );
         
			for ( int i = 0; i < m_Mobile.Skills.Length; ++i )	//Decrease all skills on pet.
			{
				if (  m_Mobile.Skills[i].Base > 10.0 )
               m_Mobile.Skills[i].Base -= 0.1;
         }
      }

      protected override void OnTick()
      {
         if ( !m_Mobile.IsDeadBondedPet )
            Stop();
         else
         {
				BaseCreature m_Pet = (BaseCreature) m_Mobile;
				
				if ( m_Pet == null )
				{
               Stop();
               return;
            }
				
            m_Pet.PlaySound( 0x214 );
				m_Pet.FixedEffect( 0x376A, 10, 16 );
				m_Pet.ResurrectPet();

            m_Pet.Emote( "*{0} je opet schopny provozu*", m_Pet.Name );
				m_Pet.Hits = m_Mobile.HitsMax / 3;
				m_Pet.Mana = m_Mobile.ManaMax / 3;
				m_Pet.Stam = m_Mobile.StamMax / 3;
            Stop();
         }
      }
   }
}